﻿Write-Output "Clean up Driver mount directory script module"
Write-Output "Version 20.10.22"
$tsenv = new-object -comobject Microsoft.SMS.TSEnvironment
$wim = "$($tsenv.value("DRIVERS01"))\Drivers.wim"
$mount = "$($tsenv.value("_SMSTSMDataPath"))\mount"
$osdisk = "$($tsenv.value("OSDisk"))\"

Write-Output "-------------------------------------------------"
Write-Output "Starting cleanup phase for drivers..."
Write-Output "-------------------------------------------------"

#Apply unmount Drivers.wim and clean up mount directory
if (test-path -path $mount) {
    Write-Output "Mount directory $mount found"
    #Unmount Mount directory
    Write-Output "Dismounting mount directory $mount"
    Dismount-WindowsImage -Path $mount -Discard
    #Remove Mount directory
    Write-Output "Removing mount directory $mount"
    Remove-Item -path $mount -force
    if (test-path -path $mount){
        Write-Output "  FAILED to Remove mount directory $mount"
        }
    else{Write-Output "  Successfully removed mount directory $mount"}
    }
else {
    Write-Output "Mount directory not found...exiting"
}

Write-Output "-------------------------------------------------"
Write-Output "Finished cleanup phase for drivers..."
Write-Output "-------------------------------------------------"